**************************************************************************************************
*******************LOCAL INCOME INEQUALITY AND HOUSEHOLD INDEBTEDNESS ****************************
*************************REGRESSION ANALYSIS *****************************************************
*************************DATE: JAN 2022 **********************************************************
*************************AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "UnbalancedHH_analytical.dta", clear

//Global vars
global DemCovar "age age2 sex Luni Lkids Ladults Lmarried Lemp Lnilf Lselfemp Duni Dkids Dadults Dmarried Demp Dnilf Dselfemp"
global FinCovar "Lginc Dginc Lassets Dassets Lfinassets Dfinassets Lliqnworth Dliqnworth"
global MacroCovar "Lmedhp Dmedhp Lurate Durate Lmedinc Dmedinc Lmeddebt Dmeddebt"

//Local Income Ranking
egen incg = xtile(inc), by(hhssa3) nq(4) 
g Lincg = L.incg

//TABLE 2: Effects of a one standard deviation increase in Gini coefficient

*Total debt
eststo m1: quietly xtreg Ddebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Mortgage debt
eststo m2: quietly xtreg Dmortgagedebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Home debt
eststo m3: quietly xtreg Dhomedebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Other property debt
eststo m4: quietly xtreg Dopropdebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Non-ortgage debt
eststo m5: quietly xtreg Dnmdebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Credit card debt
eststo m6: quietly xtreg Dccdebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Hire-purchase debt
eststo m7: quietly xtreg Dhiredebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Car debt
eststo m8: quietly xtreg Dcardebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Business debt
eststo m9: quietly xtreg Dbusdebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)
*Investment debt
eststo m10: quietly xtreg Dinvdebttoinc c.dgini#i.Lincg i.Lincg $DemCovar $FinCovar $MacroCovar c.($MacroCovar)#i.Lincg i.hhssa3#c.year if exclude==0,  vce(cluster hhssa3)

*save table
esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 using "Tables\Table Appendix - Effects of Change in Gini - Total Income Ranking.csv",  b(2) se(2) keep(*dgini*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps